<?php $__env->startSection('title', 'Meu Perfil - VideoHub'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto px-4 py-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8">
            <h1 class="text-3xl font-bold text-white">Meu Perfil</h1>
            <a href="<?php echo e(route('profile.edit')); ?>" class="bg-purple-600 hover:bg-purple-700 px-4 py-2 rounded-lg transition-colors text-white">
                <i class="fas fa-edit mr-2"></i>Editar
            </a>
        </div>

        <!-- Profile Card -->
        <div class="bg-white/5 backdrop-blur-sm rounded-2xl p-6 border border-white/10 mb-8">
            <div class="flex items-center space-x-6">
                <img src="<?php echo e($user->avatar_url); ?>" alt="<?php echo e($user->name); ?>" class="w-24 h-24 rounded-full">
                <div class="flex-1">
                    <h2 class="text-2xl font-bold text-white"><?php echo e($user->name); ?></h2>
                    <p class="text-purple-200"><?php echo e($user->email); ?></p>
                    <?php if($user->bio): ?>
                        <p class="text-purple-300 mt-2"><?php echo e($user->bio); ?></p>
                    <?php endif; ?>

                    <!-- Status do Plano -->
                    <div class="mt-4">
                        <?php if($user->hasActivePlan()): ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-600/20 text-green-400 border border-green-500/50">
                            <i class="fas fa-crown mr-2"></i>
                            <?php echo e($user->currentPlan->name); ?> - Expira em <?php echo e($user->plan_expires_at->format('d/m/Y')); ?>

                        </span>
                        <?php else: ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-600/20 text-gray-400 border border-gray-500/50">
                            <i class="fas fa-user mr-2"></i>
                            Plano Gratuito
                        </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estatísticas -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-blue-600/20 border border-blue-500/30 rounded-xl p-4 text-center">
                <div class="text-3xl font-bold text-blue-400 mb-2"><?php echo e($stats['total_logins']); ?></div>
                <div class="text-blue-200 text-sm">Total de Logins</div>
            </div>

            <div class="bg-green-600/20 border border-green-500/30 rounded-xl p-4 text-center">
                <div class="text-3xl font-bold text-green-400 mb-2"><?php echo e($stats['videos_watched']); ?></div>
                <div class="text-green-200 text-sm">Vídeos Assistidos</div>
            </div>

            <div class="bg-purple-600/20 border border-purple-500/30 rounded-xl p-4 text-center">
                <div class="text-3xl font-bold text-purple-400 mb-2"><?php echo e($user->formatWatchTime($stats['watch_time'])); ?></div>
                <div class="text-purple-200 text-sm">Tempo Assistido</div>
            </div>

            <div class="bg-yellow-600/20 border border-yellow-500/30 rounded-xl p-4 text-center">
                <div class="text-3xl font-bold text-yellow-400 mb-2"><?php echo e($stats['days_as_member']); ?></div>
                <div class="text-yellow-200 text-sm">Dias como Membro</div>
            </div>
        </div>

        <!-- Assinaturas -->
        <?php if($user->subscriptions->isNotEmpty()): ?>
            <div class="bg-white/5 backdrop-blur-sm rounded-2xl p-6 border border-white/10 mb-8">
                <h3 class="text-xl font-bold text-white mb-4">Histórico de Assinaturas</h3>

                <div class="space-y-4">
                    <?php $__currentLoopData = $user->subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-4 bg-white/5 rounded-lg">
                            <div>
                                <h4 class="font-medium text-white"><?php echo e($subscription->plan->name); ?></h4>
                                <p class="text-purple-200 text-sm">
                                    <?php echo e($subscription->starts_at->format('d/m/Y')); ?> - <?php echo e($subscription->expires_at->format('d/m/Y')); ?>

                                </p>
                            </div>
                            <div class="text-right">
                                <div class="text-white font-bold"><?php echo e($subscription->formatted_amount); ?></div>
                                <span class="text-xs px-2 py-1 rounded
                                <?php echo e($subscription->status === 'active' ? 'bg-green-600/20 text-green-400' : 'bg-gray-600/20 text-gray-400'); ?>">
                                <?php echo e($subscription->status_text); ?>

                            </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Últimas Atividades -->
        <?php if($recentActivities->isNotEmpty()): ?>
            <div class="bg-white/5 backdrop-blur-sm rounded-2xl p-6 border border-white/10">
                <h3 class="text-xl font-bold text-white mb-4">Atividades Recentes</h3>

                <div class="space-y-3">
                    <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center space-x-3 p-3 bg-white/5 rounded-lg">
                            <div class="w-8 h-8 bg-purple-600/20 rounded-full flex items-center justify-center">
                                <i class="<?php echo e($activity->action_icon); ?> text-purple-400 text-sm"></i>
                            </div>
                            <div class="flex-1">
                                <p class="text-white text-sm"><?php echo e($activity->description); ?></p>
                                <p class="text-purple-300 text-xs"><?php echo e($activity->created_at->format('d/m/Y H:i')); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Herd\Projects\videohub-app\resources\views/profile/index.blade.php ENDPATH**/ ?>