<?php //546480c4f5093531578b08b6d6c7a8db
/** @noinspection all */

namespace Illuminate\Contracts\View {

    /**
     * @method static $this extends($view, $params = [])
     * @method static $this layout($view, $params = [])
     * @method static $this layoutData($data = [])
     * @method static $this response(callable $callback)
     * @method static $this section($section)
     * @method static $this slot($slot)
     * @method static $this title($title)
     */
    class View {}
}

namespace Illuminate\Database\Eloquent {

    use Illuminate\Database\Query\Builder as QueryBuilder;
    use Illuminate\Support\HigherOrderTapProxy;
    use Kirschbaum\PowerJoins\PowerJoinClause;

    /**
     * @method static Model|HigherOrderTapProxy createOrRestore(array $attributes = [], array $values = [])
     * @method static array getAllGlobalScopes()
     * @method static mixed getGroupBy()
     * @method static array getScopes()
     * @method static mixed getSelect()
     * @method static $this hasNestedUsingJoins(string $relations, string $operator = '>=', int $count = 1, string $boolean = 'and', array|\Closure|null|string $callback = null)
     * @method static $this joinNestedRelationship(string $relationships, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure joinRelation(string $relationName, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static $this joinRelationship(string $relationName, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure joinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure leftJoinRelation(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure leftJoinRelationship(string $relationName, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure leftJoinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure leftPowerJoin($table, $first, $operator = null, $second = null)
     * @method static PowerJoinClause newPowerJoinClause(QueryBuilder $parentQuery, string $type, string $table, Model|null $model = null)
     * @method static $this onlyTrashed()
     * @method static \Closure orderByLeftPowerJoins(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByLeftPowerJoinsAvg(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByLeftPowerJoinsCount(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByLeftPowerJoinsMax(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByLeftPowerJoinsMin(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByLeftPowerJoinsSum(array|string $sort, string $direction = 'asc')
     * @method static $this orderByPowerJoins(array|string $sort, string $direction = 'asc', null|string $aggregation = null, string $joinType = 'join', $aliases = null)
     * @method static \Closure orderByPowerJoinsAvg(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByPowerJoinsCount(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByPowerJoinsMax(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByPowerJoinsMin(array|string $sort, string $direction = 'asc')
     * @method static \Closure orderByPowerJoinsSum(array|string $sort, string $direction = 'asc')
     * @method static $this powerJoin($table, $first, $operator = null, $second = null, $type = 'inner', $where = false)
     * @method static \Closure powerJoinDoesntHave($relation, $boolean = 'and', \Closure|null $callback = null)
     * @method static $this powerJoinHas(string $relation, string $operator = '>=', int $count = 1, $boolean = 'and', array|\Closure|null|string $callback = null, null|string $morphable = null)
     * @method static \Closure powerJoinWhereHas($relation, $callback = null, $operator = '>=', $count = 1)
     * @method static int restore()
     * @method static Model|HigherOrderTapProxy restoreOrCreate(array $attributes = [], array $values = [])
     * @method static \Closure rightJoinRelation(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure rightJoinRelationship(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure rightJoinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method static \Closure rightPowerJoin($table, $first, $operator = null, $second = null)
     * @method static $this withTrashed($withTrashed = true)
     * @method static $this withoutTrashed()
     */
    class Builder {}
}

namespace Illuminate\Database\Eloquent\Relations {

    use Illuminate\Database\Eloquent\Model;
    use Kirschbaum\PowerJoins\PowerJoinClause;

    /**
     * @method static void applyBasicCondition($join, $condition)
     * @method static void applyExtraConditions(PowerJoinClause $join)
     * @method static void applyNestedCondition($join, $condition)
     * @method static void applyNotNullCondition($join, $condition)
     * @method static void applyNullCondition($join, $condition)
     * @method static array|mixed exportExtraParametersForSerialize()
     * @method static Model getFarParent()
     * @method static array|string|void getPowerJoinExistenceCompareKey()
     * @method static Model getThroughParent()
     * @method static void importExtraParametersForSerialize(array $params)
     * @method static void performHavingForEloquentPowerJoins($builder, $operator, $count, null|string $morphable = null)
     * @method static \Closure performJoinForEloquentPowerJoins($builder, $joinType = 'leftJoin', $callback = null, $alias = null, bool $disableExtraConditions = false, null|string $morphable = null, bool $hasCheck = false)
     * @method static bool shouldNotApplyExtraCondition($condition)
     * @method static bool usesSoftDeletes($model)
     */
    class Relation {}
}

namespace Illuminate\Database\Query {

    use Illuminate\Contracts\Database\Query\Expression;

    /**
     * @method static array|mixed getGroupBy()
     * @method static Expression[]|mixed|string[] getSelect()
     */
    class Builder {}
}

namespace Illuminate\Routing {

    /**
     * @method static $this lazy($enabled = true)
     */
    class Route {}
}

namespace Illuminate\Support {

    /**
     * @method static string sanitizeHtml(string $html)
     * @method static string ucwords(string $value)
     */
    class Str {}

    /**
     * @method static $this sanitizeHtml()
     * @method static $this ucwords()
     */
    class Stringable {}
}

namespace Illuminate\Testing {

    /**
     * @method static $this assertDontSeeLivewire($component)
     * @method static $this assertSeeLivewire($component)
     */
    class TestResponse {}

    /**
     * @method static $this assertDontSeeLivewire($component)
     * @method static $this assertSeeLivewire($component)
     */
    class TestView {}
}

namespace Illuminate\View {

    use Livewire\WireDirective;

    /**
     * @method static WireDirective wire($name)
     */
    class ComponentAttributeBag {}

    /**
     * @method static $this extends($view, $params = [])
     * @method static $this layout($view, $params = [])
     * @method static $this layoutData($data = [])
     * @method static $this response(callable $callback)
     * @method static $this section($section)
     * @method static $this slot($slot)
     * @method static $this title($title)
     */
    class View {}
}

namespace Laravel\Dusk {

    /**
     * @method static $this assertAttributeMissing($selector, $attribute)
     * @method static $this assertClassMissing($selector, $className)
     * @method static $this|void assertConsoleLogHasWarning($expectedMessage)
     * @method static $this|void assertConsoleLogMissingWarning($expectedMessage)
     * @method static $this assertHasClass($selector, $className)
     * @method static $this|void assertInViewPort($selector, $invert = false)
     * @method static \Closure assertNotInViewPort($selector)
     * @method static $this|void assertNotPresent($selector)
     * @method static $this|void assertNotVisible($selector)
     * @method static $this|void assertScript($js, $expects = true)
     * @method static mixed offline()
     * @method static mixed online()
     * @method static $this runScript($js)
     * @method static $this scrollTo($selector)
     * @method static $this selectMultiple($field, $values = [])
     * @method static object waitForLivewire($callback = null)
     * @method static mixed waitForLivewireToLoad()
     * @method static object waitForNavigate($callback = null)
     * @method static object waitForNavigateRequest($callback = null)
     * @method static object waitForNoLivewire($callback = null)
     * @method static object waitForNoNavigateRequest($callback = null)
     */
    class Browser {}
}

namespace Livewire\Features\SupportTesting {

    use Filament\Actions\Testing\TestsActions;
    use Illuminate\Support\Collection;

    /**
     * @method static $this assertActionDataSet(array $data)
     * @method static $this assertActionDisabled(array|string $name)
     * @method static $this assertActionDoesNotExist(array|string $name)
     * @method static $this assertActionDoesNotHaveColor(array|string $name, array|string $color, $record = null)
     * @method static $this assertActionDoesNotHaveIcon(array|string $name, string $icon, $record = null)
     * @method static $this assertActionDoesNotHaveLabel(array|string $name, string $label, $record = null)
     * @method static $this assertActionDoesNotHaveUrl(array|string $name, string $url, $record = null)
     * @method static $this assertActionEnabled(array|string $name)
     * @method static $this assertActionExists(array|string $name)
     * @method static $this assertActionHasColor(array|string $name, array|string $color, $record = null)
     * @method static $this assertActionHasIcon(array|string $name, string $icon, $record = null)
     * @method static $this assertActionHasLabel(array|string $name, string $label, $record = null)
     * @method static $this assertActionHasUrl(array|string $name, string $url, $record = null)
     * @method static $this assertActionHidden(array|string $name, array $arguments = [])
     * @method static TestsActions assertActionListInOrder(array $names, array $actions, string $actionType, string $actionClass)
     * @method static $this assertActionMounted(array|string $name)
     * @method static $this assertActionNotMounted(array|string $name)
     * @method static $this assertActionShouldNotOpenUrlInNewTab(array|string $name, $record = null)
     * @method static $this assertActionShouldOpenUrlInNewTab(array|string $name, $record = null)
     * @method static $this assertActionVisible(array|string $name, array $arguments = [])
     * @method static $this assertCanNotRenderTableColumn(string $name)
     * @method static $this assertCanNotSeeTableRecords(array|Collection $records)
     * @method static $this assertCanRenderTableColumn(string $name)
     * @method static $this assertCanSeeTableRecords(array|Collection $records, bool $inOrder = false)
     * @method static $this assertCountTableRecords(int $count)
     * @method static $this assertFormComponentActionDataSet(array $data)
     * @method static $this assertFormComponentActionDisabled(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionDoesNotExist(array|string $component, array|string $name, string $formName = 'form')
     * @method static $this assertFormComponentActionDoesNotHaveColor(array|string $component, array|string $name, array|string $color, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionDoesNotHaveIcon(array|string $component, array|string $name, string $icon, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionDoesNotHaveLabel(array|string $component, array|string $name, string $label, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionDoesNotHaveUrl(array|string $component, array|string $name, string $url, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionEnabled(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionExists(array|string $component, array|string $name, string $formName = 'form')
     * @method static $this assertFormComponentActionHasColor(array|string $component, array|string $name, array|string $color, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionHasIcon(array|string $component, array|string $name, string $icon, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionHasLabel(array|string $component, array|string $name, string $label, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionHasUrl(array|string $component, array|string $name, string $url, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionHidden(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionMounted(array|string $component, array|string $name, string $formName = 'form')
     * @method static $this assertFormComponentActionNotMounted(array|string $component, array|string $name, string $formName = 'form')
     * @method static $this assertFormComponentActionShouldNotOpenUrlInNewTab(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionShouldOpenUrlInNewTab(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentActionVisible(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this assertFormComponentDoesNotExist(string $componentKey, string $formName = 'form')
     * @method static $this assertFormComponentExists(string $componentKey, \Closure|string $formName = 'form', \Closure|null $checkComponentUsing = null)
     * @method static $this assertFormExists(string $name = 'form')
     * @method static $this assertFormFieldDoesNotExist(string $fieldName, string $formName = 'form')
     * @method static $this assertFormFieldExists(string $fieldName, \Closure|string $formName = 'form', \Closure|null $checkFieldUsing = null)
     * @method static $this assertFormFieldIsDisabled(string $fieldName, string $formName = 'form')
     * @method static $this assertFormFieldIsEnabled(string $fieldName, string $formName = 'form')
     * @method static $this assertFormFieldIsHidden(string $fieldName, string $formName = 'form')
     * @method static $this assertFormFieldIsReadOnly(string $fieldName, string $formName = 'form')
     * @method static $this assertFormFieldIsVisible(string $fieldName, string $formName = 'form')
     * @method static $this assertFormSet(array|\Closure $state, string $formName = 'form')
     * @method static $this assertHasActionErrors(array $keys = [])
     * @method static $this assertHasFormComponentActionErrors(array $keys = [])
     * @method static $this assertHasFormErrors(array $keys = [], string $formName = 'form')
     * @method static $this assertHasInfolistActionErrors(array $keys = [])
     * @method static $this assertHasNoActionErrors(array $keys = [])
     * @method static $this assertHasNoFormComponentActionErrors(array $keys = [])
     * @method static $this assertHasNoFormErrors(array $keys = [], string $formName = 'form')
     * @method static $this assertHasNoInfolistActionErrors(array $keys = [])
     * @method static $this assertHasNoTableActionErrors(array $keys = [])
     * @method static $this assertHasNoTableBulkActionErrors(array $keys = [])
     * @method static $this assertHasTableActionErrors(array $keys = [])
     * @method static $this assertHasTableBulkActionErrors(array $keys = [])
     * @method static $this assertInfolistActionDataSet(array $data)
     * @method static $this assertInfolistActionDisabled(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionDoesNotExist(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionDoesNotHaveColor(string $component, array|string $name, array|string $color, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionDoesNotHaveIcon(string $component, array|string $name, string $icon, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionDoesNotHaveLabel(string $component, array|string $name, string $label, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionDoesNotHaveUrl(string $component, array|string $name, string $url, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionEnabled(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionExists(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionHasColor(string $component, array|string $name, array|string $color, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionHasIcon(string $component, array|string $name, string $icon, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionHasLabel(string $component, array|string $name, string $label, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionHasUrl(string $component, array|string $name, string $url, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionHidden(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionMounted(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionNotMounted(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionShouldNotOpenUrlInNewTab(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionShouldOpenUrlInNewTab(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertInfolistActionVisible(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this assertTableActionDataSet(array|\Closure $state)
     * @method static $this assertTableActionDisabled(array|string $name, $record = null)
     * @method static $this assertTableActionDoesNotExist(array|string $name, \Closure|null $checkActionUsing = null, $record = null)
     * @method static $this assertTableActionDoesNotHaveColor(array|string $name, array|string $color, $record = null)
     * @method static $this assertTableActionDoesNotHaveIcon(array|string $name, string $icon, $record = null)
     * @method static $this assertTableActionDoesNotHaveLabel(array|string $name, string $label, $record = null)
     * @method static $this assertTableActionDoesNotHaveUrl(array|string $name, string $url, $record = null)
     * @method static $this assertTableActionEnabled(array|string $name, $record = null)
     * @method static $this assertTableActionExists(array|string $name, \Closure|null $checkActionUsing = null, $record = null)
     * @method static $this assertTableActionHasColor(array|string $name, array|string $color, $record = null)
     * @method static $this assertTableActionHasIcon(array|string $name, string $icon, $record = null)
     * @method static $this assertTableActionHasLabel(array|string $name, string $label, $record = null)
     * @method static $this assertTableActionHasUrl(array|string $name, string $url, $record = null)
     * @method static $this assertTableActionHidden(array|string $name, $record = null)
     * @method static $this assertTableActionMounted(array|string $name)
     * @method static $this assertTableActionNotMounted(array|string $name)
     * @method static $this assertTableActionShouldNotOpenUrlInNewTab(array|string $name, $record = null)
     * @method static $this assertTableActionShouldOpenUrlInNewTab(array|string $name, $record = null)
     * @method static $this assertTableActionVisible(array|string $name, $record = null)
     * @method static $this assertTableActionsExistInOrder(array $names)
     * @method static $this assertTableBulkActionDataSet(array|\Closure $state)
     * @method static $this assertTableBulkActionDisabled(string $name)
     * @method static $this assertTableBulkActionDoesNotExist(string $name)
     * @method static $this assertTableBulkActionDoesNotHaveColor(string $name, array|string $color, $record = null)
     * @method static $this assertTableBulkActionDoesNotHaveIcon(string $name, string $icon, $record = null)
     * @method static $this assertTableBulkActionDoesNotHaveLabel(string $name, string $label, $record = null)
     * @method static $this assertTableBulkActionEnabled(string $name)
     * @method static $this assertTableBulkActionExists(string $name)
     * @method static $this assertTableBulkActionHasColor(string $name, array|string $color, $record = null)
     * @method static $this assertTableBulkActionHasIcon(string $name, string $icon, $record = null)
     * @method static $this assertTableBulkActionHasLabel(string $name, string $label, $record = null)
     * @method static $this assertTableBulkActionHidden(string $name)
     * @method static $this assertTableBulkActionMounted(string $name)
     * @method static $this assertTableBulkActionNotMounted(string $name)
     * @method static $this assertTableBulkActionVisible(string $name)
     * @method static $this assertTableBulkActionsExistInOrder(array $names)
     * @method static $this assertTableColumnDoesNotExist(string $name, \Closure|null $checkColumnUsing = null, $record = null)
     * @method static $this|void assertTableColumnDoesNotHaveDescription(string $name, $description, $record, string $position = 'below')
     * @method static $this|void assertTableColumnDoesNotHaveExtraAttributes(string $name, array $attributes, $record)
     * @method static $this assertTableColumnExists(string $name, \Closure|null $checkColumnUsing = null, $record = null)
     * @method static $this assertTableColumnFormattedStateNotSet(string $name, $value, $record)
     * @method static $this assertTableColumnFormattedStateSet(string $name, $value, $record)
     * @method static $this|void assertTableColumnHasDescription(string $name, $description, $record, string $position = 'below')
     * @method static $this|void assertTableColumnHasExtraAttributes(string $name, array $attributes, $record)
     * @method static $this assertTableColumnHidden(string $name)
     * @method static $this assertTableColumnStateNotSet(string $name, $value, $record)
     * @method static $this assertTableColumnStateSet(string $name, $value, $record)
     * @method static $this assertTableColumnSummarizerExists(string $columnName, string $summarizerId)
     * @method static $this assertTableColumnSummaryNotSet(string $columnName, string $summarizerId, $state, bool $isCurrentPaginationPageOnly = false)
     * @method static $this assertTableColumnSummarySet(string $columnName, string $summarizerId, $state, bool $isCurrentPaginationPageOnly = false)
     * @method static $this assertTableColumnVisible(string $name)
     * @method static $this assertTableEmptyStateActionsExistInOrder(array $names)
     * @method static $this assertTableFilterExists(string $name, \Closure|null $checkFilterUsing = null)
     * @method static $this assertTableFilterHidden(string $name)
     * @method static $this assertTableFilterVisible(string $name)
     * @method static $this assertTableHeaderActionsExistInOrder(array $names)
     * @method static $this|void assertTableSelectColumnDoesNotHaveOptions(string $name, array $options, $record)
     * @method static $this|void assertTableSelectColumnHasOptions(string $name, array $options, $record)
     * @method static $this assertWizardCurrentStep(int $step, string $formName = 'form')
     * @method static $this assertWizardStepExists(int $step, string $formName = 'form')
     * @method static $this callAction(array|string $name, array $data = [], array $arguments = [])
     * @method static $this callFormComponentAction(array|string $component, array|string $name, array $data = [], array $arguments = [], string $formName = 'form')
     * @method static $this callInfolistAction(string $component, array|string $name, array $data = [], array $arguments = [], string $infolistName = 'infolist')
     * @method static $this callMountedAction(array $arguments = [])
     * @method static $this callMountedFormComponentAction(array $arguments = [])
     * @method static $this callMountedInfolistAction(array $arguments = [])
     * @method static $this callMountedTableAction(array $arguments = [])
     * @method static $this callMountedTableBulkAction(array $arguments = [])
     * @method static $this callTableAction(array|string $name, $record = null, array $data = [], array $arguments = [])
     * @method static $this callTableBulkAction(string $name, array|Collection $records, array $data = [], array $arguments = [])
     * @method static $this callTableColumnAction(string $name, $record = null)
     * @method static $this fillForm(array|\Closure $state = [], string $formName = 'form')
     * @method static $this filterTable(string $name, $data = null)
     * @method static array getNestedFormComponentActionComponentAndName(array|string $component, array|string $name, string $formName = 'form', array $arguments = [])
     * @method static array getNestedInfolistActionComponentAndName(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this goToNextWizardStep(string $formName = 'form')
     * @method static $this goToPreviousWizardStep(string $formName = 'form')
     * @method static $this goToWizardStep(int $step, string $formName = 'form')
     * @method static $this loadTable()
     * @method static $this mountAction(array|string $name, array $arguments = [])
     * @method static $this mountFormComponentAction(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method static $this mountInfolistAction(string $component, array|string $name, string $infolistName = 'infolist')
     * @method static $this mountTableAction(array|string $name, $record = null)
     * @method static $this mountTableBulkAction(string $name, array|Collection $records)
     * @method static string parseActionName(string $name)
     * @method static array parseNestedActionName(array|string $name)
     * @method static array parseNestedFormComponentActionComponentAndName(array|string $component, array|string $name, string $formName = 'form')
     * @method static $this removeTableFilter(string $filter, null|string $field = null)
     * @method static $this removeTableFilters()
     * @method static $this resetTableFilters()
     * @method static $this searchTable(null|string $search = null)
     * @method static $this searchTableColumns(array $searches)
     * @method static $this setActionData(array $data)
     * @method static $this setFormComponentActionData(array $data)
     * @method static $this setInfolistActionData(array $data)
     * @method static $this setTableActionData(array $data)
     * @method static $this setTableBulkActionData(array $data)
     * @method static $this sortTable(null|string $name = null, null|string $direction = null)
     * @method static $this unmountAction()
     * @method static $this unmountFormComponentAction()
     * @method static $this unmountInfolistAction()
     * @method static $this unmountTableAction()
     */
    class Testable {}
}
