<?php $__env->startSection('title', 'Planos - VideoHub'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Hero Section -->
        <section class="text-center mb-16 animate-fade-in">
            <div class="relative">
                <div class="absolute inset-0 bg-gradient-to-r from-purple-600/20 to-pink-600/20 rounded-3xl blur-3xl"></div>
                <div class="relative bg-white/5 backdrop-blur-sm rounded-3xl p-8 md:p-12 border border-white/10">
                    <h2 class="text-4xl md:text-5xl font-bold mb-6 bg-gradient-to-r from-purple-400 via-pink-400 to-purple-400 bg-clip-text text-transparent">
                        Escolha Seu Plano
                    </h2>
                    <p class="text-lg md:text-xl text-purple-200 max-w-3xl mx-auto mb-8">
                        Acesso ilimitado a todos os cursos e materiais exclusivos.
                        Cancele quando quiser, sem complicações.
                    </p>
                </div>
            </div>
        </section>

        <!-- Planos -->
        <section class="mb-16">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginal4b9f0e385130d3dde0c764d2d7390b81 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b9f0e385130d3dde0c764d2d7390b81 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.plan-card','data' => ['plan' => $plan,'featured' => $plan->is_popular]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('plan-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['plan' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($plan),'featured' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($plan->is_popular)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b9f0e385130d3dde0c764d2d7390b81)): ?>
<?php $attributes = $__attributesOriginal4b9f0e385130d3dde0c764d2d7390b81; ?>
<?php unset($__attributesOriginal4b9f0e385130d3dde0c764d2d7390b81); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b9f0e385130d3dde0c764d2d7390b81)): ?>
<?php $component = $__componentOriginal4b9f0e385130d3dde0c764d2d7390b81; ?>
<?php unset($__componentOriginal4b9f0e385130d3dde0c764d2d7390b81); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </section>

        <!-- FAQ -->
        <section class="bg-white/5 backdrop-blur-sm rounded-3xl p-8 md:p-12 border border-white/10">
            <h3 class="text-2xl font-bold text-center mb-8 text-white">Perguntas Frequentes</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div>
                    <h4 class="text-lg font-bold text-white mb-2">Posso cancelar a qualquer momento?</h4>
                    <p class="text-purple-200">Sim! Você pode cancelar sua assinatura a qualquer momento sem taxas de cancelamento.</p>
                </div>

                <div>
                    <h4 class="text-lg font-bold text-white mb-2">Os certificados são reconhecidos?</h4>
                    <p class="text-purple-200">Nossos certificados são reconhecidos por empresas parceiras e podem ser adicionados ao seu LinkedIn.</p>
                </div>

                <div>
                    <h4 class="text-lg font-bold text-white mb-2">Posso assistir offline?</h4>
                    <p class="text-purple-200">Atualmente os vídeos precisam ser assistidos online, mas estamos trabalhando na funcionalidade offline.</p>
                </div>

                <div>
                    <h4 class="text-lg font-bold text-white mb-2">Há suporte técnico?</h4>
                    <p class="text-purple-200">Sim! Oferecemos suporte via chat e email para todos os assinantes.</p>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Herd\Projects\videohub-app\resources\views/plans.blade.php ENDPATH**/ ?>