


<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['plan', 'featured' => false]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['plan', 'featured' => false]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="bg-white/5 backdrop-blur-sm rounded-2xl p-8 border border-white/10 hover:border-purple-500/50 transition-all duration-300 <?php echo e($featured ? 'transform scale-105 border-2 border-purple-500/50 relative' : ''); ?>">
    <?php if($featured): ?>
        <div class="absolute -top-4 left-1/2 transform -translate-x-1/2 bg-gradient-to-r from-purple-500 to-pink-500 px-4 py-1 rounded-full text-sm font-bold text-white">
            MAIS POPULAR
        </div>
    <?php endif; ?>

    <div class="text-center">
        <h4 class="text-xl font-bold text-white mb-2"><?php echo e($plan->name); ?></h4>
        <div class="text-3xl font-bold text-purple-400 mb-1"><?php echo e($plan->formatted_price); ?></div>
        <div class="text-sm text-purple-200 mb-4"><?php echo e($plan->billing_cycle_text); ?></div>

        <?php if($plan->description): ?>
            <p class="text-purple-200 text-sm mb-6"><?php echo e($plan->description); ?></p>
        <?php endif; ?>

        <ul class="text-purple-200 space-y-2 mb-6 text-left">
            <?php $__currentLoopData = $plan->features_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="flex items-center">
                    <i class="fas fa-check text-green-400 mr-2 flex-shrink-0"></i>
                    <span><?php echo e($feature); ?></span>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        <?php if(auth()->guard()->check()): ?>
            <?php if(auth()->user()->hasActivePlan()): ?>
                <button disabled class="w-full bg-gray-600 text-gray-300 font-medium py-3 rounded-lg cursor-not-allowed">
                    <i class="fas fa-check mr-2"></i>
                    Plano Ativo
                </button>
            <?php else: ?>
                <a
                    href="<?php echo e(route('subscription.checkout', $plan->slug)); ?>"
                    class="block w-full <?php echo e($featured ? 'bg-gradient-to-r from-purple-500 to-pink-500 hover:from-purple-600 hover:to-pink-600' : 'bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-700 hover:to-purple-800'); ?> text-white font-medium py-3 rounded-lg transition-all duration-300 text-center"
                >
                    Escolher Plano
                </a>
            <?php endif; ?>
        <?php else: ?>
            <a
                href="<?php echo e(route('register')); ?>"
                class="block w-full <?php echo e($featured ? 'bg-gradient-to-r from-purple-500 to-pink-500 hover:from-purple-600 hover:to-pink-600' : 'bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-700 hover:to-purple-800'); ?> text-white font-medium py-3 rounded-lg transition-all duration-300 text-center"
            >
                Começar Agora
            </a>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\Herd\Projects\videohub-app\resources\views/components/plan-card.blade.php ENDPATH**/ ?>